# Code for estimating standard errors with the data from schools of size between 4 and 150

# Import packages
import os, sys
import numpy as np
import pandas as pd
import pickle, math
import random 
from sklearn.linear_model import LinearRegression 
from sklearn.metrics import r2_score 
import scipy.optimize
from multiprocessing import Process
import multiprocessing

# Define functions
# adjacency matrix to pairs
def adjpair_dir(A):
    N=A.shape[0]
    y=np.array([0])
    for k in range(1,N+1):
        a=np.concatenate((A[0:k-1,k-1],A[k:N+1,k-1]),axis=0)
        y=np.append(y,a,axis=0)
    return y[1:y.shape[0]+1] 

# eigenvector condition
def eigcons_b(p,Xcell1,Xcell2,D,ep):
    H=len(Xcell1)
    X1=Xcell1[0]
    beta0=p[0]
    K=X1.shape[2]
    beta=p[1:2*K+1]
    alpha=abs(p[2*K+1])
    R=100
    qm=np.zeros((H))
    sig2=abs(p[2*K+3])
    for h in range(1,H+1):
        X1=Xcell1[h-1]
        X2=Xcell2[h-1]
        N=X1.shape[0]
        Xarray1=np.zeros((N,N,K))
        Xarray2=np.zeros((N,N,K))
        for k in range(1,K+1):
            Xarray1[:,:,k-1]=X1[:,:,k-1]*beta[k-1]
            Xarray2[:,:,k-1]=X2[:,:,k-1]*beta[K+k-1]
        XB=np.sum(Xarray1,axis=2)+np.sum(Xarray2,axis=2)+(np.ones((N,N))-np.identity(N))*beta0
        Delta=D[h-1]
        q=np.zeros((R))
        EP=ep[h-1]
        for r in range(1,101):
            ER=sig2*EP[:,:,r-1]
            B1=XB+ER
            a=np.amax(np.linalg.eig(B1)[0])
            if a==0:
                q[r-1]=-999
            else:
                q[r-1]=1/a-alpha/N 
        qm[h-1]=np.amin(q)
    return np.amin(qm)

# Finding the weight matrix
def fwmatrix(SDcell,Xcell1,Xcell2,ADcell,D):
    H=len(SDcell) 
    k1=Xcell1[0].shape[2] 
    R=100 
    K=k1*2 
    N1=np.zeros(1) 
    N2=np.zeros(1) 
    XX=np.zeros((1,K+1)) 
    A1=np.zeros(1) 
    for h in range(1,H+1):
        N=SDcell[h-1].shape[0] 
        A=SDcell[h-1] # N matrix (directed)
        F=ADcell[h-1] # A matrix (directed)
        F1obs=adjpair_dir(F) # Convert A matrix into N(N-1) by 1 vector of a_ij's.
        A1=np.concatenate((A1,F1obs),axis=0) 
        m=int(N*(N-1)) 
        X1=np.zeros((m,K+1)) 
        for k in range(1,k1+1):
            X1[:,k-1]=adjpair_dir(Xcell1[h-1][:,:,k-1])
            X1[:,k1+k-1]=adjpair_dir(Xcell2[h-1][:,:,k-1])
        X1[:,K]=adjpair_dir(D[h-1]) 
        XX=np.concatenate((XX,X1),axis=0) 
        N1obs=adjpair_dir(A) 
        N2obs=adjpair_dir(A*A)
        N1=np.concatenate((N1,N1obs),axis=0)
        N2=np.concatenate((N2,N2obs),axis=0)    
    # Delete the first observation that was a placeholder
    xdata=XX[1:XX.shape[0]+1,:] 
    ydata1=N1[1:N1.shape[0]+1] 
    ydata2=N2[1:N2.shape[0]+1] 
    Adata=A1[1:A1.shape[0]+1] 
    AY=np.where(Adata>0)*1 
    xdataF=xdata[AY] 
    ydata1F=ydata1[AY]
    ydata2F=ydata2[AY]
    LM1 = LinearRegression().fit(xdataF,ydata1F)     # Linear regression of N_ij on X
    mu11=LM1.coef_
    mu12=np.array([LM1.intercept_])
    mu13=np.array([LM1.score(xdataF,ydata1F)])
    mu1=np.concatenate((mu12,mu11),axis=0)
    mu1=np.concatenate((mu1,mu13),axis=0)
    LM2 = LinearRegression().fit(xdataF,ydata2F) # Linear regression of N^2_ij on X
    mu23=np.array([LM2.score(xdataF,ydata2F)])
    mu=np.concatenate((mu1,mu23),axis=0)
    num_mu=mu.shape[0] 
    B2=3000
    bp=np.ceil(H*np.random.uniform(0,1,(H,B2))) 
    muset=np.zeros((num_mu,B2)) 
    for b in range(1,B2+1):
        hi=bp[:,b-1] 
        XXb=np.zeros((1,23)) 
        N1b=np.zeros((1))
        N2b=np.zeros((1))
        FAb=np.zeros((1)) 
        for q in range(1,H+1):
            h=int(hi[q-1]) 
            A=SDcell[h-1] 
            Fb=adjpair_dir(ADcell[h-1])
            Nb=A.shape[0] 
            m=int(Nb*(Nb-1)) 
            X1b=np.zeros((m,K+1))
            for k in range(1,k1+1):
                X1b[:,k-1]=adjpair_dir(Xcell1[h-1][:,:,k-1])
                X1b[:,k1+k-1]=adjpair_dir(Xcell2[h-1][:,:,k-1])
            X1b[:,K]=adjpair_dir(D[h-1])
            XXb=np.concatenate((XXb,X1b),axis=0)
            N1bb=adjpair_dir(A)
            N2bb=adjpair_dir(A*A)
            N1b=np.concatenate((N1b,N1bb),axis=0)
            N2b=np.concatenate((N2b,N2bb),axis=0) 
            FAb=np.concatenate((FAb,Fb),axis=0)
        # Drop the first obs of zero that was a placeholder.
        Xdtb=XXb[1:XXb.shape[0]+1,:]
        N1dtb=N1b[1:N1b.shape[0]+1]
        N2dtb=N2b[1:N2b.shape[0]+1]
        Fdtb=FAb[1:FAb.shape[0]+1]
        AYb=np.where(Fdtb>0)*1
        XXbF=Xdtb[AYb]
        N1bF=N1dtb[AYb]
        N2bF=N2dtb[AYb] 
        LM1b = LinearRegression().fit(XXbF,N1bF)
        mu11=LM1b.coef_
        mu12=np.array([LM1b.intercept_])
        mu13=np.array([LM1b.score(XXbF,N1bF)])
        mu1=np.concatenate((mu12,mu11),axis=0)
        mu1b=np.concatenate((mu1,mu13),axis=0)
        LM2b = LinearRegression().fit(XXbF,N2bF)
        mu2b=np.array([LM2b.score(XXbF,N2bF)])
        mub=np.concatenate((mu1b,mu2b),axis=0)
        muset[:,b-1]=mub
    VA=np.cov(muset) 
    WA=np.linalg.inv(VA) 
    Wresult=[WA,mu,xdataF,AY]
    return Wresult

# Objective function for each bootstrap sample
def socint_objb(p,Xcell1,Xcell2,D,EPcell,mu,WA,xdataF,AY):
    if eigcons_b(p,Xcell1,Xcell2,D,EPcell)>0:
        H=len(Xcell1)
        K=Xcell1[0].shape[2]
        beta0=p[0]
        beta=p[1:2*K+1]
        alpha=abs(p[2*K+1])
        c=abs(p[2*K+2])
        sig=abs(p[2*K+3])
        R=100
        mut=np.zeros((K+4,R))
        XBc=[]
        for h in range(1,H+1):
            N=Xcell1[h-1].shape[0]
            Xarray1=np.zeros((N,N,K))
            Xarray2=np.zeros((N,N,K))
            X1=Xcell1[h-1]
            X2=Xcell2[h-1]
            for k in range(1,K+1):
                Xarray1[:,:,k-1]=X1[:,:,k-1]*beta[k-1]
                Xarray2[:,:,k-1]=X2[:,:,k-1]*beta[K+k-1]
            XBc.append(np.sum(Xarray1,axis=2)+np.sum(Xarray2,axis=2)+(np.ones((N,N))-np.identity(N))*beta0)
        mut=np.zeros((2*K+4,R))
        for r in range(1,R+1):
            Nh=np.array([0]) 
            Nh2=np.array([0])
            for h in range(1,H+1):
                XB=XBc[h-1]
                N=XB.shape[0]
                Delta=D[h-1] 
                EP=EPcell[h-1]
                ER=sig*EP[:,:,r-1]
                A=np.identity(N)-alpha*(XB+ER)/N
                s_star= np.matmul(np.linalg.inv(A)*(np.identity(N)-alpha*c*Delta),np.ones((N,1)))
                Nhat=(XB-c*np.divide(Delta,(np.ones((N,1))*np.transpose(s_star)+ER)))*(np.ones((N,N))-np.identity(N))
                Nhat0=np.floor(Nhat) 
                Nhat1=np.minimum(Nhat0,5*np.ones((N,N)))
                Nhat2=Nhat1**2
                NHij=adjpair_dir(Nhat1)
                NH2ij=adjpair_dir(Nhat2)
                Nh=np.concatenate((Nh,NHij))
                Nh2=np.concatenate((Nh2,NH2ij))
            Nh=Nh[1:Nh.shape[0]+1]
            Nh2=Nh2[1:Nh2.shape[0]+1]
            NhF=Nh[AY]
            Nh2F=Nh2[AY]
            LM1 = LinearRegression().fit(xdataF,NhF)
            mu11=LM1.coef_
            mu12=np.array([LM1.intercept_])
            mu13=np.array([LM1.score(xdataF,NhF)])
            mu1=np.concatenate((mu12,mu11),axis=0)
            mu1=np.concatenate((mu1,mu13),axis=0)
            LM2 = LinearRegression().fit(xdataF,Nh2F)
            mu23=np.array([LM2.score(xdataF,Nh2F)])
            mut[:,r-1]=np.concatenate((mu1,mu23)) 
        mh=np.mean(mut,axis=1)
        Qn=np.matmul(np.matmul(np.transpose(mh-mu),((1+1/R)**(-1))*WA),mh-mu)
        return Qn
    else:
        return np.inf    

if __name__ == '__main__':

    with open('spatial_interaction_finaldata_schools4to150.pkl','rb') as f:
        Data=pickle.load(f)
    with open('Xdata_pair_level_Schools4to150.pkl','rb') as f:
        xdata=pickle.load(f)
    with open('II_Results_Schools4to150.pkl','rb') as f:
        Result=pickle.load(f)
    Scell=Data[0]
    SDcell=Data[1]
    Xcell1=Data[2]
    Xcell2=Data[3]
    D=Data[4]
    EPcell=Data[5]
    st_list=Data[6]
    GE=Data[7]
    ADcell=Data[9]
    H=len(Scell)
    X1=[]
    k1=Xcell1[0].shape[2]
    for h in range(1,H+1):
        X1.append(abs(Xcell1[h-1]))
    Xcell=X1
    K=k1*2
    st=Result[0]
    B=100
    R=100
    np.random.seed(301)
    H1=np.ceil(H*0.3) 
    BS=np.zeros((int(H1),B))
    for b in range(1,B+1):   
        BS[:,b-1]=np.random.permutation(H)[0:int(H1)]
    ResultB=np.zeros((B,K+4))
    for b in range(1,B+1):
        bi=BS[:,b-1]
        Xc1b=[]
        Xc2b=[]
        Db=[]
        EPb=[]
        SDb=[]
        ADb=[]
        for j in range(1,int(H1)+1):
            qb=int(bi[j-1])
            Xc1b.append(X1[qb])
            Xc2b.append(Xcell2[qb])
            Db.append(D[qb])
            EPb.append(EPcell[qb])
            SDb.append(SDcell[qb])
            ADb.append(ADcell[qb])
        FWr=fwmatrix(SDb,Xc1b,Xc2b,ADb,Db)
        WAb=FWr[0]
        mub=FWr[1]
        xdataFb=FWr[2]
        AYb=FWr[3]
        thb=scipy.optimize.fmin(socint_objb,st,args=(Xc1b,Xc2b,Db,EPb,mub,WAb,xdataFb,AYb))
        ResultB[b-1,:]=thb   
    STD=np.std(ResultB,axis=0)
    RE=[ResultB,STD]
    with open("SE_schools_4to150_results.pkl",'wb') as f:
        pickle.dump(RE,f)
